-- Flemming


set sql_safe_updates=0;

-- HOMEWORK_ASSIGNMENT_SUBMISSION_ALL_INDIVIDUAL        
SET @homeworkAssignment=(SELECT id FROM dtprovider WHERE `dataProviderName`='HOMEWORK_ASSIGNMENT_SUBMISSION_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T10.firstName AS FIRST_NAME,
    T10.lastName AS LAST_NAME,
    T10.printName AS PRINT_NAME,
    T10.emailId AS EMAIL_ID,
    T10.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T10.mobileNumber AS MOBILE_NO,
    T10.mobileCountryCode AS MOBILE_CODE,
    T5.academyName AS ACADEMY_NAME,
    T5.locationName AS LOCATION_NAME,
    T5.displayName AS ACADEMY_NAME_LOCATION,
    T6.assignmentName AS ASSIGNMENT_NAME,
    T8.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
    T8.courseCode AS COURSE_CODE,
    T7.courseVariantCode AS COURSE_VARIANT_CODE,
    T7.courseVariantDescription AS COURSE_VARIANT_DESCRIPTION,
    T4.firstName AS STUDENT_FIRSTNAME,
    T4.lastName AS STUDENT_LASTNAME,
    T12.salutationName AS SALUTATION_NAME,
    ml.code as LANGUAGE_KEY
FROM
    group_hw_assignment T1
        LEFT JOIN
    admission AS T2 ON T2.id = T1.admissionId
        LEFT JOIN
    students AS T3 ON T3.userId = T2.studentId
        LEFT JOIN
    persons AS T4 ON T4.id = T3.personId
        LEFT JOIN
    academy_location T5 ON T5.id = T2.academyLocationId
        LEFT JOIN
    course_hw_asignment T6 ON T6.id = T1.hwAssignmentId
        LEFT JOIN
    course_variants T7 ON T7.id = T6.courseVariantId
        LEFT JOIN
    courses T8 ON T8.id = T7.courseId
        LEFT JOIN
    staffs T9 ON T9.userId = T6.facultyId
        LEFT JOIN
    persons AS T10 ON T10.id = T9.personId
        LEFT JOIN
    salutations T12 ON T12.id = T10.salutationId
		LEFT JOIN
	multi_language ml on ml.id=T10.correspondence_language
WHERE
    T1.id IN (namedParams)" WHERE `dataProviderId`=@homeworkAssignment;  
  
  
  
  -- UPDATE_ATTENDANCE_DAY_WISE_STUDENT
        
SET @updateAttendanceDayWiseStudent=(SELECT id FROM dtprovider WHERE `dataProviderName`='UPDATE_ATTENDANCE_DAY_WISE_STUDENT_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T2.id AS ID,
    T5.firstName AS FIRST_NAME,
    T5.lastName AS LAST_NAME,
    T5.printName AS PRINT_NAME,
    T5.emailId AS EMAIL_ID,
    T5.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T5.mobileNumber AS MOBILE_NO,
    T5.mobileCountryCode AS MOBILE_CODE,
    T6.displayName AS ACADEMY_NAME,
    DATE_FORMAT(T1.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID,
    (CASE
        WHEN
            (T9.itemValue = T9.attendanceStatus)
        THEN
            CONCAT(UCASE(LEFT(T9.attendanceStatus, 1)),
                    LCASE(SUBSTRING(T9.attendanceStatus, 2)))
        ELSE CONCAT(T9.itemValue,
                '/',
                CONCAT(UCASE(LEFT(T9.attendanceStatus, 1)),
                        LCASE(SUBSTRING(T9.attendanceStatus, 2))))
    END) AS ATTENDANCE_STATUS,
    T8.printName AS FACULTY_PRINT_NAME,
    DATE_FORMAT(DATE(NOW()), '%d-%m-%Y') AS TODAY_DATE,
    ml.code as LANGUAGE_KEY
FROM
    student_program_attendance T1
        LEFT JOIN
    student_program_attendance_details T2 ON T2.attendanceId = T1.id
        LEFT JOIN
    admission T3 ON T3.id = T2.admissionId
        LEFT JOIN
    students T4 ON T4.userId = T3.studentId
        LEFT JOIN
    persons T5 ON T5.id = T4.personId
        LEFT JOIN
    academy_location T6 ON T6.id = T1.academyLocationId
        LEFT JOIN
    staffs T7 ON T7.userId = T2.lastUpdatedBy
        LEFT JOIN
    persons T8 ON T8.id = T7.personId
        LEFT JOIN
    attendance_marking_type AS T9 ON T9.id = T2.attendanceMarkingTypeId
        LEFT JOIN
    fire_base_persons_info f ON f.userId = T4.userId
        LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
WHERE
    T2.id IN (namedParams) group by T2.id" WHERE `dataProviderId`=@updateAttendanceDayWiseStudent; 
    
-- UPDATE_ATTENDANCE_COURSE_WISE_STUDENT
        
SET @updateAttendanceCourseWiseStudent=(SELECT id FROM dtprovider WHERE `dataProviderName`='UPDATE_ATTENDANCE_COURSE_WISE_STUDENT_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="
SELECT 
    scad.id AS ID,
    T1.courseVariantCode AS COURSE_VARIANT_CODE,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    T7.printName AS PRINT_NAME,
    T7.emailId AS EMAIL_ID,
    T7.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T8.displayName AS ACADEMY_NAME,
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID,
    DATE_FORMAT(sca.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,
    DATE_FORMAT(sca.fromTime, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(sca.toTime, '%h:%i %p') AS SLOT_TO,
    (CASE
        WHEN
            (T9.itemValue = T9.attendanceStatus)
        THEN
            CONCAT(UCASE(LEFT(T9.attendanceStatus, 1)),
                    LCASE(SUBSTRING(T9.attendanceStatus, 2)))
        ELSE CONCAT(T9.itemValue,
                '/',
                CONCAT(UCASE(LEFT(T9.attendanceStatus, 1)),
                        LCASE(SUBSTRING(T9.attendanceStatus, 2))))
    END) AS ATTENDANCE_STATUS,
    T11.printName AS FACULTY_PRINT_NAME,
    DATE_FORMAT(DATE(NOW()), '%d-%m-%Y') AS TODAY_DATE,
    ml.code as LANGUAGE_KEY
FROM
    student_course_attendance sca
        LEFT JOIN
    student_course_attendance_details scad ON sca.id = scad.attendanceId
        LEFT JOIN
    course_variants T1 ON T1.id = sca.variantId
        LEFT JOIN
    admission T5 ON T5.id = scad.admissionId
        LEFT JOIN
    students T6 ON T6.userId = T5.studentId
        LEFT JOIN
    persons T7 ON T7.id = T6.personId
        LEFT JOIN
    academy_location T8 ON T8.id = sca.academyLocationId
        LEFT JOIN
    staffs T10 ON T10.userId = scad.lastUpdatedBy
        LEFT JOIN
    persons T11 ON T11.id = T10.personId
        LEFT JOIN
    attendance_marking_type AS T9 ON T9.id = scad.attendanceMarkingTypeId
        LEFT JOIN
    fire_base_persons_info f ON f.userId = T6.userId
        LEFT JOIN
	multi_language ml on ml.id=T7.correspondence_language
WHERE
    scad.id IN (namedParams) group by scad.id" WHERE `dataProviderId`=@updateAttendanceCourseWiseStudent; 


-- ATTENDANCE_DAY_WISE_GUARDIAN_PRESENT_ONLY
        
SET @attendanceDayWiseGuardian=(SELECT id FROM dtprovider WHERE `dataProviderName`='STUDENT_MARKED_PRESENT_CD_MS_GUARDIAN_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,
    T10.sessionNo as SESSION_NUMBER,   
    (case when (T2.itemValue = T2.attendanceStatus) then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) as ATTENDANCE_STATUS,
    date_format(DATE(NOW()), '%d-%m-%Y') as TODAY_DATE,
    ml.code as LANGUAGE_KEY
FROM
    student_program_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_program_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T1.lastUpdatedBy
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
	LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
WHERE
T1.id IN (namedParams) AND T7.isMobUseForCommunication = TRUE  AND T6.relationship = 'GUARDIAN' AND T6.whetherDeleted = false" WHERE `dataProviderId`=@attendanceDayWiseGuardian; 

-- ATTENDANCE_DAY_WISE_GUARDIAN_PRESENT_ONLY
        
SET @attendanceDayWiseGuardian2=(SELECT id FROM dtprovider WHERE `dataProviderName`='STUDENT_MARKED_PRESENT_CD_MS_LOCAL_GUARDIAN_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
    ml.code as LANGUAGE_KEY,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,    
    (case when (T2.itemValue = 'Present' and T2.attendanceStatus = 'PRESENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     when (T2.itemValue = 'Absent' and T2.attendanceStatus = 'ABSENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
    else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) AS ATTENDANCE_STATUS
FROM
    student_program_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_program_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T10.facultyId
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
    LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
WHERE
T1.id IN (namedParams) AND T2.attendanceStatus = 'PRESENT' AND T7.isMobUseForCommunication = TRUE  AND T6.relationship = 'LOCAL_GUARDIAN' AND T6.whetherDeleted = false" WHERE `dataProviderId`=@attendanceDayWiseGuardian2; 
   
-- ATTENDANCE_DAY_WISE_PARENT_ABSENT_ONLY
        
SET @attendanceDayWiseParentAbsent=(SELECT id FROM dtprovider WHERE `dataProviderName`='ATTENDANCE_DAY_WISE_FATHER_ABSENT_ONLY_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
    ml.code as LANGUAGE_KEY,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,    
    (case when (T2.itemValue = 'Present' and T2.attendanceStatus = 'PRESENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     when (T2.itemValue = 'Absent' and T2.attendanceStatus = 'ABSENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
    else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) AS ATTENDANCE_STATUS
FROM
    student_program_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_program_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T10.facultyId
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
    LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
WHERE
T1.id IN (namedParams) AND T2.attendanceStatus = 'ABSENT' AND T7.isMobUseForCommunication = TRUE  AND T6.relationship = 'FATHER' AND T6.whetherDeleted = false" WHERE `dataProviderId`=@attendanceDayWiseParentAbsent; 


-- ATTENDANCE_DAY_WISE_PARENT_ABSENT_ONLY
        
SET @attendanceDayWiseParentAbsent2=(SELECT id FROM dtprovider WHERE `dataProviderName`='ATTENDANCE_DAY_WISE_MOTHER_ABSENT_ONLY_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
    ml.code as LANGUAGE_KEY,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,    
    (case when (T2.itemValue = 'Present' and T2.attendanceStatus = 'PRESENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     when (T2.itemValue = 'Absent' and T2.attendanceStatus = 'ABSENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
    else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) AS ATTENDANCE_STATUS
FROM
    student_program_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_program_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T10.facultyId
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
    LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
WHERE
T1.id IN (namedParams) AND T2.attendanceStatus = 'ABSENT' AND T7.isMobUseForCommunication = TRUE  AND T6.relationship = 'MOTHER' AND T6.whetherDeleted = false" WHERE `dataProviderId`=@attendanceDayWiseParentAbsent2;          
 
 
 -- ATTENDANCE_DAY_WISE_GUARDIAN_ABSENT_ONLY
        
SET @attendanceDayWiseGuardianAbsent=(SELECT id FROM dtprovider WHERE `dataProviderName`='ATTENDANCE_DAY_WISE_GUARDIAN_ABSENT_ONLY_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,    
    (case when (T2.itemValue = 'Present' and T2.attendanceStatus = 'PRESENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     when (T2.itemValue = 'Absent' and T2.attendanceStatus = 'ABSENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
    else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) AS ATTENDANCE_STATUS,
    ml.code as LANGUAGE_KEY
FROM
    student_program_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_program_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T10.facultyId
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
    LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
WHERE
T1.id IN (namedParams) AND T2.attendanceStatus = 'ABSENT' AND T7.isMobUseForCommunication = TRUE  AND T6.relationship = 'GUARDIAN' AND T6.whetherDeleted = false" WHERE `dataProviderId`=@attendanceDayWiseGuardianAbsent;          
   

 -- ATTENDANCE_DAY_WISE_GUARDIAN_ABSENT_ONLY
        
SET @attendanceDayWiseGuardianAbsent2=(SELECT id FROM dtprovider WHERE `dataProviderName`='ATTENDANCE_DAY_WISE_LOCAL_GUARDIAN_ABSENT_ONLY_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,    
    (case when (T2.itemValue = 'Present' and T2.attendanceStatus = 'PRESENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     when (T2.itemValue = 'Absent' and T2.attendanceStatus = 'ABSENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
    else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) AS ATTENDANCE_STATUS,
    ml.code as LANGUAGE_KEY
FROM
    student_program_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_program_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T10.facultyId
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
     LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
WHERE
T1.id IN (namedParams) AND T2.attendanceStatus = 'ABSENT' AND T7.isMobUseForCommunication = TRUE  AND T6.relationship = 'LOCAL_GUARDIAN' AND T6.whetherDeleted = false" WHERE `dataProviderId`=@attendanceDayWiseGuardianAbsent2;          
      
      
      
 -- ATTENDANCE_COURSE_WISE_PARENT_PRESENT_ONLY
        
SET @attendanceCourseWiseParentAbsent=(SELECT id FROM dtprovider WHERE `dataProviderName`='ATTENDANCE_COURSE_WISE_FATHER_PRESENT_ONLY_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
    T14.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,
	DATE_FORMAT(T10.fromTime, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T10.toTime, '%h:%i %p') AS SLOT_TO,    
    (case when (T2.itemValue = 'Present' and T2.attendanceStatus = 'PRESENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     when (T2.itemValue = 'Absent' and T2.attendanceStatus = 'ABSENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
    else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) AS ATTENDANCE_STATUS,
    ml.code as LANGUAGE_KEY
FROM
    student_course_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_course_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T10.facultyId
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
    LEFT JOIN
    courses AS T14 ON T14.id = T10.courseId
    LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
WHERE
T1.id IN (namedParams) AND T2.attendanceStatus = 'PRESENT' AND T7.isMobUseForCommunication = TRUE AND T6.relationship = 'FATHER'" WHERE `dataProviderId`=@attendanceCourseWiseParentAbsent;          
  
  -- ATTENDANCE_COURSE_WISE_PARENT_ABSENT_ONLY
        
SET @attendanceCourseWiseParentAbsent2=(SELECT id FROM dtprovider WHERE `dataProviderName`='ATTENDANCE_COURSE_WISE_FATHER_ABSENT_ONLY_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
    T14.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,
	DATE_FORMAT(T10.fromTime, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T10.toTime, '%h:%i %p') AS SLOT_TO,    
    (case when (T2.itemValue = 'Present' and T2.attendanceStatus = 'PRESENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     when (T2.itemValue = 'Absent' and T2.attendanceStatus = 'ABSENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
    else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) AS ATTENDANCE_STATUS,
    ml.code as LANGUAGE_KEY
FROM
    student_course_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_course_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T10.facultyId
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
    LEFT JOIN
    courses AS T14 ON T14.id = T10.courseId
    LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
WHERE
T1.id IN (namedParams) AND T2.attendanceStatus = 'PRESENT' AND T7.isMobUseForCommunication = TRUE AND T6.relationship = 'MOTHER'" WHERE `dataProviderId`=@attendanceCourseWiseParentAbsent2;          
 
 
   -- ATTENDANCE_COURSE_WISE_PARENT_PRESENT_ONLY
        
SET @attendanceCourseWiseParentOnly=(SELECT id FROM dtprovider WHERE `dataProviderName`='ATTENDANCE_COURSE_WISE_MOTHER_PRESENT_ONLY_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
    T14.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,
	DATE_FORMAT(T10.fromTime, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T10.toTime, '%h:%i %p') AS SLOT_TO,    
    (case when (T2.itemValue = 'Present' and T2.attendanceStatus = 'PRESENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     when (T2.itemValue = 'Absent' and T2.attendanceStatus = 'ABSENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
    else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) AS ATTENDANCE_STATUS,
    ml.code as LANGUAGE_KEY
FROM
    student_course_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_course_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T10.facultyId
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
    LEFT JOIN
    courses AS T14 ON T14.id = T10.courseId
	LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
WHERE
T1.id IN (namedParams) AND T2.attendanceStatus = 'ABSENT' AND T7.isMobUseForCommunication = TRUE AND T6.relationship = 'FATHER' AND T6.whetherDeleted = false" WHERE `dataProviderId`=@attendanceCourseWiseParentOnly;  


   -- ATTENDANCE_COURSE_WISE_PARENT_PRESENT_ONLY
        
SET @attendanceCourseWiseParentOnly2=(SELECT id FROM dtprovider WHERE `dataProviderName`='ATTENDANCE_COURSE_WISE_MOTHER_ABSENT_ONLY_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
    T14.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,
	DATE_FORMAT(T10.fromTime, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T10.toTime, '%h:%i %p') AS SLOT_TO,    
    (case when (T2.itemValue = 'Present' and T2.attendanceStatus = 'PRESENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     when (T2.itemValue = 'Absent' and T2.attendanceStatus = 'ABSENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
    else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) AS ATTENDANCE_STATUS,
    ml.code as LANGUAGE_KEY
FROM
    student_course_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_course_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T10.facultyId
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
    LEFT JOIN
    courses AS T14 ON T14.id = T10.courseId
    LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
WHERE
T1.id IN (namedParams) AND T2.attendanceStatus = 'ABSENT' AND T7.isMobUseForCommunication = TRUE AND T6.relationship = 'MOTHER' AND T6.whetherDeleted = false" WHERE `dataProviderId`=@attendanceCourseWiseParentOnly2;   


   -- ATTENDANCE_COURSE_WISE_GUARDIAN_PRESENT_ONLY
        
SET @attendanceCourseWiseGrdnPsnt=(SELECT id FROM dtprovider WHERE `dataProviderName`='ATTENDANCE_COURSE_WISE_GUARDIAN_PRESENT_ONLY_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
    T14.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,
	DATE_FORMAT(T10.fromTime, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T10.toTime, '%h:%i %p') AS SLOT_TO,    
    (case when (T2.itemValue = 'Present' and T2.attendanceStatus = 'PRESENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     when (T2.itemValue = 'Absent' and T2.attendanceStatus = 'ABSENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
    else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) AS ATTENDANCE_STATUS,
    ml.code as LANGUAGE_KEY
FROM
    student_course_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_course_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T10.facultyId
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
    LEFT JOIN
    courses AS T14 ON T14.id = T10.courseId
    LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
WHERE
T1.id IN (namedParams) AND T2.attendanceStatus = 'PRESENT' AND T7.isMobUseForCommunication = TRUE AND T6.relationship = 'GUARDIAN' AND T6.whetherDeleted = false" WHERE `dataProviderId`=@attendanceCourseWiseGrdnPsnt; 


   -- ATTENDANCE_COURSE_WISE_GUARDIAN_PRESENT_ONLY
        
SET @attendanceCourseWiseGrdnPsnt2=(SELECT id FROM dtprovider WHERE `dataProviderName`='ATTENDANCE_COURSE_WISE_LOCAL_GUARDIAN_PRESENT_ONLY_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
    T14.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,
	DATE_FORMAT(T10.fromTime, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T10.toTime, '%h:%i %p') AS SLOT_TO,    
    (case when (T2.itemValue = 'Present' and T2.attendanceStatus = 'PRESENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     when (T2.itemValue = 'Absent' and T2.attendanceStatus = 'ABSENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
    else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) AS ATTENDANCE_STATUS,
    ml.code as LANGUAGE_KEY
FROM
    student_course_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_course_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T10.facultyId
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
    LEFT JOIN
    courses AS T14 ON T14.id = T10.courseId
    LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
WHERE
T1.id IN (namedParams) AND T2.attendanceStatus = 'PRESENT' AND T7.isMobUseForCommunication = TRUE AND T6.relationship = 'LOCAL_GUARDIAN'" WHERE `dataProviderId`=@attendanceCourseWiseGrdnPsnt2;   

   -- ATTENDANCE_COURSE_WISE_GUARDIAN_ABSENT_ONLY
        
SET @attendanceCourseWiseGrdnAbnt=(SELECT id FROM dtprovider WHERE `dataProviderName`='ATTENDANCE_COURSE_WISE_GUARDIAN_ABSENT_ONLY_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
    T14.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,
	DATE_FORMAT(T10.fromTime, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T10.toTime, '%h:%i %p') AS SLOT_TO,    
    (case when (T2.itemValue = 'Present' and T2.attendanceStatus = 'PRESENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     when (T2.itemValue = 'Absent' and T2.attendanceStatus = 'ABSENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
    else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) AS ATTENDANCE_STATUS,
    ml.code as LANGUAGE_KEY
FROM
    student_course_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_course_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T10.facultyId
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
    LEFT JOIN
    courses AS T14 ON T14.id = T10.courseId
    LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
WHERE
T1.id IN (namedParams) AND T2.attendanceStatus = 'ABSENT' AND T7.isMobUseForCommunication = TRUE AND T6.relationship = 'GUARDIAN' AND T6.whetherDeleted = false" WHERE `dataProviderId`=@attendanceCourseWiseGrdnAbnt; 


   -- ATTENDANCE_COURSE_WISE_GUARDIAN_ABSENT_ONLY
        
SET @attendanceCourseWiseGrdnAbnt2=(SELECT id FROM dtprovider WHERE `dataProviderName`='ATTENDANCE_COURSE_WISE_LOCAL_GUARDIAN_ABSENT_ONLY_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
    T14.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,
	DATE_FORMAT(T10.fromTime, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T10.toTime, '%h:%i %p') AS SLOT_TO,    
    (case when (T2.itemValue = 'Present' and T2.attendanceStatus = 'PRESENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     when (T2.itemValue = 'Absent' and T2.attendanceStatus = 'ABSENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
    else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) AS ATTENDANCE_STATUS,
    ml.code as LANGUAGE_KEY
FROM
    student_course_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_course_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T10.facultyId
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
    LEFT JOIN
    courses AS T14 ON T14.id = T10.courseId
    LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
WHERE
T1.id IN (namedParams) AND T2.attendanceStatus = 'ABSENT' AND T7.isMobUseForCommunication = TRUE AND T6.relationship = 'LOCAL_GUARDIAN' AND T6.whetherDeleted = false" WHERE `dataProviderId`=@attendanceCourseWiseGrdnAbnt2; 


   -- HOMEWORK_ASSIGNMENT_SUBMISSION_GROUP
        
SET @HomeworkAssignmentSub=(SELECT id FROM dtprovider WHERE `dataProviderName`='HOMEWORK_ASSIGNMENT_SUBMISSION_GRP_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T6.id AS ID,
    T10.firstName AS FIRST_NAME,
    T10.lastName AS LAST_NAME,
    T10.printName AS PRINT_NAME,
    T10.emailId AS EMAIL_ID,
    T10.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T10.mobileNumber AS MOBILE_NO,
    T10.mobileCountryCode AS MOBILE_CODE,
    T5.academyName AS ACADEMY_NAME,
    T5.locationName AS LOCATION_NAME,
    T5.displayName AS ACADEMY_NAME_LOCATION,
    T6.assignmentName AS ASSIGNMENT_NAME,
    T1.groupName AS GROUP_NAME,
    T8.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
    T8.courseCode AS COURSE_CODE,
    T7.courseVariantCode AS COURSE_VARIANT_CODE,
    T7.courseVariantDescription AS COURSE_VARIANT_DESCRIPTION,
    T4.firstName AS STUDENT_FIRSTNAME,
    T4.lastName AS STUDENT_LASTNAME,
    T12.salutationName AS SALUTATION_NAME,
    T13.code AS CODE,
    ml.code as LANGUAGE_KEY
FROM
    group_hw_assignment T1
        LEFT JOIN
    admission AS T2 ON T2.id = T1.admissionId
        LEFT JOIN
    students AS T3 ON T3.userId = T2.studentId
        LEFT JOIN
    persons AS T4 ON T4.id = T3.personId
        LEFT JOIN
    academy_location T5 ON T5.id = T2.academyLocationId
        LEFT JOIN
    course_hw_asignment T6 ON T6.id = T1.hwAssignmentId
        LEFT JOIN
    course_variants T7 ON T7.id = T6.courseVariantId
        LEFT JOIN
    courses T8 ON T8.id = T7.courseId
        LEFT JOIN
    staffs T9 ON T9.userId = T6.facultyId
        LEFT JOIN
    persons AS T10 ON T10.id = T9.personId
        LEFT JOIN
    salutations T12 ON T12.id = T10.salutationId
        LEFT JOIN
    users T13 ON T13.id = T3.userId
       LEFT JOIN
	multi_language ml on ml.id=T10.correspondence_language
WHERE
    T6.id IN (namedParams)" WHERE `dataProviderId`=@HomeworkAssignmentSub;
    
   -- UPDATE_ATTENDANCE_DAY_WISE_PARENT
        
SET @updateAttendanceDayWiseParent=(SELECT id FROM dtprovider WHERE `dataProviderName`='UPDATE_ATTENDANCE_DAY_WISE_FATHER_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
    ml.code as LANGUAGE_KEY,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,    
(case when (T2.itemValue = T2.attendanceStatus) then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) as ATTENDANCE_STATUS,
date_format(DATE(NOW()), '%d-%m-%Y') as TODAY_DATE
FROM
    student_program_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_program_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T1.lastUpdatedBy
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
    LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
WHERE
T1.id IN (namedParams) AND T7.isMobUseForCommunication = TRUE  AND T6.relationship = 'FATHER' AND T6.whetherDeleted = false" WHERE `dataProviderId`=@updateAttendanceDayWiseParent;    

   -- UPDATE_ATTENDANCE_DAY_WISE_PARENT
        
SET @updateAttendanceDayWiseParent2=(SELECT id FROM dtprovider WHERE `dataProviderName`='UPDATE_ATTENDANCE_DAY_WISE_MOTHER_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
    ml.code as LANGUAGE_KEY,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,    
(case when (T2.itemValue = T2.attendanceStatus) then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) as ATTENDANCE_STATUS,
date_format(DATE(NOW()), '%d-%m-%Y') as TODAY_DATE
FROM
    student_program_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_program_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T1.lastUpdatedBy
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
    LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
WHERE
T1.id IN (namedParams) AND T7.isMobUseForCommunication = TRUE  AND T6.relationship = 'MOTHER' AND T6.whetherDeleted = false" WHERE `dataProviderId`=@updateAttendanceDayWiseParent2;   
    

   -- UPDATE_ATTENDANCE_DAY_WISE_LOCAL_GUARDIAN
        
SET @updateAttendanceDayWiseLocalGrdn=(SELECT id FROM dtprovider WHERE `dataProviderName`='UPDATE_ATTENDANCE_DAY_WISE_GUARDIAN_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
    ml.code as LANGUAGE_KEY,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,    
    (case when (T2.itemValue = T2.attendanceStatus) then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) as ATTENDANCE_STATUS,
    date_format(DATE(NOW()), '%d-%m-%Y') as TODAY_DATE
FROM
    student_program_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_program_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T1.lastUpdatedBy
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
    LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
WHERE
T1.id IN (namedParams) AND T7.isMobUseForCommunication = TRUE  AND T6.relationship = 'GUARDIAN' AND T6.whetherDeleted = false" WHERE `dataProviderId`=@updateAttendanceDayWiseLocalGrdn; 
 
    -- UPDATE_ATTENDANCE_DAY_WISE_LOCAL_GUARDIAN
        
SET @updateAttendanceDayWiseLocalGrdn2=(SELECT id FROM dtprovider WHERE `dataProviderName`='UPDATE_ATTENDANCE_DAY_WISE_LOCAL_GUARDIAN_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
    ml.code as LANGUAGE_KEY,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,    
    (case when (T2.itemValue = T2.attendanceStatus) then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) as ATTENDANCE_STATUS,
    date_format(DATE(NOW()), '%d-%m-%Y') as TODAY_DATE
FROM
    student_program_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_program_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T1.lastUpdatedBy
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
    LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
WHERE
T1.id IN (namedParams) AND T7.isMobUseForCommunication = TRUE  AND T6.relationship = 'LOCAL_GUARDIAN' AND T6.whetherDeleted = false" WHERE `dataProviderId`=@updateAttendanceDayWiseLocalGrdn2; 


    -- UPDATE_ATTENDANCE_COURSE_WISE_PARENT
        
SET @updateAttendanceCourseWisePrnt=(SELECT id FROM dtprovider WHERE `dataProviderName`='UPDATE_ATTENDANCE_COURSE_WISE_FATHER_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
    T14.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
    T16.courseVariantCode AS COURSE_VARIANT_CODE,
	T14.courseCode AS COURSE_CODE,
    ml.code as LANGUAGE_KEY,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,
	DATE_FORMAT(T10.fromTime, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T10.toTime, '%h:%i %p') AS SLOT_TO,    
   (case when (T15.itemValue = T15.attendanceStatus) then CONCAT(UCASE(LEFT(T15.attendanceStatus, 1)), LCASE(SUBSTRING(T15.attendanceStatus, 2)))
     else CONCAT(T15.itemValue, '/', CONCAT(UCASE(LEFT(T15.attendanceStatus, 1)), LCASE(SUBSTRING(T15.attendanceStatus, 2))))
    end) as ATTENDANCE_STATUS,
    date_format(DATE(NOW()), '%d-%m-%Y') as TODAY_DATE
FROM
    student_course_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_course_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T1.lastUpdatedBy
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
    LEFT JOIN
    courses AS T14 ON T14.id = T10.courseId
left join
 attendance_marking_type AS T15 ON T15.id = T1.attendanceMarkingTypeId
LEFT JOIN
    course_variants T16 ON T16.id = T10.variantId
    LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language    
WHERE
T1.id IN (namedParams)  AND T7.isMobUseForCommunication = TRUE AND T6.relationship = 'FATHER' AND T6.whetherDeleted = false" WHERE `dataProviderId`=@updateAttendanceCourseWisePrnt;    



    -- UPDATE_ATTENDANCE_COURSE_WISE_PARENT
        
SET @updateAttendanceCourseWisePrnt2=(SELECT id FROM dtprovider WHERE `dataProviderName`='UPDATE_ATTENDANCE_COURSE_WISE_MOTHER_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
    T14.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
    T16.courseVariantCode AS COURSE_VARIANT_CODE,
	T14.courseCode AS COURSE_CODE,
    ml.code as LANGUAGE_KEY,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,
	DATE_FORMAT(T10.fromTime, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T10.toTime, '%h:%i %p') AS SLOT_TO,    
   (case when (T15.itemValue = T15.attendanceStatus) then CONCAT(UCASE(LEFT(T15.attendanceStatus, 1)), LCASE(SUBSTRING(T15.attendanceStatus, 2)))
     else CONCAT(T15.itemValue, '/', CONCAT(UCASE(LEFT(T15.attendanceStatus, 1)), LCASE(SUBSTRING(T15.attendanceStatus, 2))))
    end) as ATTENDANCE_STATUS,
    date_format(DATE(NOW()), '%d-%m-%Y') as TODAY_DATE
FROM
    student_course_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_course_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T1.lastUpdatedBy
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
    LEFT JOIN
    courses AS T14 ON T14.id = T10.courseId
    left join
    attendance_marking_type AS T15 ON T15.id = T1.attendanceMarkingTypeId
    LEFT JOIN
    course_variants T16 ON T16.id = T10.variantId
    LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
WHERE
T1.id IN (namedParams)  AND T7.isMobUseForCommunication = TRUE AND T6.relationship = 'MOTHER' AND T6.whetherDeleted = false" WHERE `dataProviderId`=@updateAttendanceCourseWisePrnt2;   

    -- UPDATE_ATTENDANCE_COURSE_WISE_LOCAL_GUARDIAN
        
SET @updateAttendanceCourseWiseGrdn=(SELECT id FROM dtprovider WHERE `dataProviderName`='UPDATE_ATTENDANCE_COURSE_WISE_GUARDIAN_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
    T14.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
    T16.courseVariantCode AS COURSE_VARIANT_CODE,
	T14.courseCode AS COURSE_CODE,
    ml.code as LANGUAGE_KEY,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,
	DATE_FORMAT(T10.fromTime, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T10.toTime, '%h:%i %p') AS SLOT_TO,    
   (case when (T15.itemValue = T15.attendanceStatus) then CONCAT(UCASE(LEFT(T15.attendanceStatus, 1)), LCASE(SUBSTRING(T15.attendanceStatus, 2)))
     else CONCAT(T15.itemValue, '/', CONCAT(UCASE(LEFT(T15.attendanceStatus, 1)), LCASE(SUBSTRING(T15.attendanceStatus, 2))))
    end) as ATTENDANCE_STATUS,
    date_format(DATE(NOW()), '%d-%m-%Y') as TODAY_DATE
FROM
    student_course_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_course_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T1.lastUpdatedBy
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
    LEFT JOIN
    courses AS T14 ON T14.id = T10.courseId
left join
 attendance_marking_type AS T15 ON T15.id = T1.attendanceMarkingTypeId
LEFT JOIN
    course_variants T16 ON T16.id = T10.variantId
    LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
WHERE
T1.id IN (namedParams)  AND T7.isMobUseForCommunication = TRUE AND T6.relationship = 'GUARDIAN' AND T6.whetherDeleted = false" WHERE `dataProviderId`=@updateAttendanceCourseWiseGrdn;   

    -- UPDATE_ATTENDANCE_COURSE_WISE_LOCAL_GUARDIAN
        
SET @updateAttendanceCourseWiseGrdn2=(SELECT id FROM dtprovider WHERE `dataProviderName`='UPDATE_ATTENDANCE_COURSE_WISE_LOCAL_GUARDIAN_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
    T14.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
    T16.courseVariantCode AS COURSE_VARIANT_CODE,
	T14.courseCode AS COURSE_CODE,
    ml.code as LANGUAGE_KEY,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,
	DATE_FORMAT(T10.fromTime, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T10.toTime, '%h:%i %p') AS SLOT_TO,    
   (case when (T15.itemValue = T15.attendanceStatus) then CONCAT(UCASE(LEFT(T15.attendanceStatus, 1)), LCASE(SUBSTRING(T15.attendanceStatus, 2)))
     else CONCAT(T15.itemValue, '/', CONCAT(UCASE(LEFT(T15.attendanceStatus, 1)), LCASE(SUBSTRING(T15.attendanceStatus, 2))))
    end) as ATTENDANCE_STATUS,
    date_format(DATE(NOW()), '%d-%m-%Y') as TODAY_DATE
FROM
    student_course_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_course_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T1.lastUpdatedBy
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
    LEFT JOIN
    courses AS T14 ON T14.id = T10.courseId
    left join
    attendance_marking_type AS T15 ON T15.id = T1.attendanceMarkingTypeId
    LEFT JOIN
    course_variants T16 ON T16.id = T10.variantId
    LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
WHERE
T1.id IN (namedParams)  AND T7.isMobUseForCommunication = TRUE AND T6.relationship = 'LOCAL_GUARDIAN' AND T6.whetherDeleted = false" WHERE `dataProviderId`=@updateAttendanceCourseWiseGrdn2;  

 set sql_safe_updates=1;

